#include <pigpio.h>
#include <iostream>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

static void err_handler (int sig) {
    gpioTerminate();
    signal(SIGINT, SIG_DFL);
    kill(getppid(), SIGINT);
    kill(getpid(), SIGINT);
    exit(0);
}

static void exit_handler () {
    gpioTerminate();
}



using namespace std;

int main() {
   
    if (gpioInitialise() < 0) return 1;
    signal(SIGQUIT, err_handler);
    signal(SIGINT, err_handler);
    signal(SIGTERM, err_handler);
    signal(SIGABRT, err_handler);
    atexit(exit_handler);

   int bitLower = 21;
   int bit2 = 20;
   int bit3 = 16;
   int bit4 = 12;
   
   gpioSetMode(bitLower, PI_OUTPUT);
   gpioSetMode(bit2, PI_OUTPUT);
   gpioSetMode(bit3, PI_OUTPUT);
   gpioSetMode(bit4, PI_OUTPUT);
   
   // acc name is LSM9DS1
   
   // write 11000000 to 0x20
   // read 0x28 and 0x29. lsb is in 28
   // its address is 0xD4. if that doesn't work try 0xD6, or d53 or d54
   
   // make sure the right bus is being used
   int accHandle = i2cOpen(1, 0x35, 0);
   
   if(accHandle < 0 ) {
       cout << "i2c fail" << endl;
   }
   
   i2cWriteByteData(accHandle, 0x20, 0xC0);
   
   // not sure if seconds or milliseconds
   time_sleep(1);
   
   while(1) {
       int superAcc = i2cReadWordData(accHandle, 0x28);
       
       cout << "acc gotten is " << superAcc << endl;
       
       int writeEm = superAcc >>(12);
       
       gpioWrite(bit4, (writeEm & 0x08) == 0x08);
       gpioWrite(bit3, (writeEm & 0x04) == 0x04);
       gpioWrite(bit2, (writeEm & 0x02) == 0x02);
       gpioWrite(bitLower, (writeEm & 0x01) == 0x01);
       time_sleep(1);
      }
   
   
}
